<?php
// modules/materials/controller.php (base-compatible)
// FIX: created_at обязателен + current_price/price + обработка дубля имени (uq_materials_name) без fatal

require_once __DIR__ . '/flash.php';

if (!function_exists('materials__table_exists')) {
function materials__table_exists($name) {
    $name = db_escape($name);
    $r = db_fetch_one(db_query("SELECT 1 x FROM information_schema.tables WHERE table_schema=DATABASE() AND table_name='$name' LIMIT 1"));
    return !empty($r);
}
}

if (!function_exists('materials__has_col')) {
function materials__has_col($table, $col) {
    static $cache = [];
    $k = $table . '.' . $col;
    if (isset($cache[$k])) return $cache[$k];
    $t = db_escape($table);
    $c = db_escape($col);
    $r = db_fetch_one(db_query("SELECT 1 x FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='$t' AND column_name='$c' LIMIT 1"));
    $cache[$k] = !empty($r);
    return $cache[$k];
}
}

if (!function_exists('materials__resolve_table')) {
function materials__resolve_table($type) {
    if ($type === 'tool') {
        if (materials__table_exists('tools')) return ['tools', null];
        return ['materials', materials__has_col('materials','type') ? "type='tool'" : null];
    }
    if ($type === 'consumable') {
        if (materials__table_exists('consumables')) return ['consumables', null];
        return ['materials', materials__has_col('materials','type') ? "type='consumable'" : null];
    }
    return ['materials', materials__has_col('materials','type') ? "type='material'" : null];
}
}

if (!function_exists('materials__price_col')) {
function materials__price_col($table) {
    if (materials__has_col($table,'current_price')) return 'current_price';
    if (materials__has_col($table,'price')) return 'price';
    return null;
}
}

if (!function_exists('materials_index')) {
function materials_index() {
    $u = require_login();
    $type = $_GET['type'] ?? 'material';
    if (!in_array($type, ['material','tool','consumable'], true)) $type='material';

    [$table, $whereType] = materials__resolve_table($type);
    $where = "1=1";
    if ($whereType) $where .= " AND $whereType";

    $catJoin = materials__has_col($table,'category_id')
        ? "LEFT JOIN material_categories c ON c.id=m.category_id"
        : "LEFT JOIN material_categories c ON 1=0";
    $catSel  = "c.name AS category_name";

    $rows = db_fetch_all(db_query("
        SELECT m.*, $catSel
        FROM `$table` m
        $catJoin
        WHERE $where
        ORDER BY m.name
    "));

    render('materials/index', ['u'=>$u,'type'=>$type,'rows'=>$rows]);
}
}

if (!function_exists('materials_edit')) {
function materials_edit() {
    $u = require_role(['admin','director','storekeeper','prod_head']);

    $type = $_GET['type'] ?? ($_POST['type'] ?? 'material');
    if (!in_array($type, ['material','tool','consumable'], true)) $type='material';

    [$table, $whereType] = materials__resolve_table($type);
    $id = (int)($_GET['id'] ?? $_POST['id'] ?? 0);

    if (isset($_GET['del']) && $id>0) {
        db_query("DELETE FROM `$table` WHERE id=$id LIMIT 1");
        if (function_exists('audit')) audit('DELETE',$table,$id,(int)$u['id'], ['event'=>'Удалено','table'=>$table,'id'=>$id], 'materials');
        header("Location: index.php?m=materials&a=index&type=$type");
        exit;
    }

    $cats = db_fetch_all(db_query("SELECT id,name FROM material_categories ORDER BY name"));

    $row = ['id'=>0,'code'=>'','name'=>'','unit'=>'','description'=>'','category_id'=>0,'is_active'=>1];
    $priceCol = materials__price_col($table);
    if ($priceCol) $row[$priceCol] = null;

    $hasMinimum = materials__has_col($table,'minimum_qty');
    if ($hasMinimum) $row['minimum_qty'] = '';

    if ($id>0) {
        $r = db_fetch_one(db_query("SELECT * FROM `$table` WHERE id=$id LIMIT 1"));
        if ($r) $row = array_merge($row, $r);
    }

    if ($_SERVER['REQUEST_METHOD']==='POST' && ($_POST['do'] ?? '')==='save') {
        $code = trim($_POST['code'] ?? '');
        $name = trim($_POST['name'] ?? '');
        $unit = trim($_POST['unit'] ?? '');
        $desc = trim($_POST['description'] ?? '');
        $cat_id = (int)($_POST['category_id'] ?? 0);
        $is_active = isset($_POST['is_active']) ? 1 : 0;

        $price_in = trim($_POST['price'] ?? '');
        $min_in = trim($_POST['minimum_qty'] ?? '');

        if ($name==='') {
            materials_flash_set('mat_err','Укажите название.');
        } else if ($unit==='') {
            materials_flash_set('mat_err','Укажите единицу измерения.');
        } else {
            // Проверка уникальности имени (uq_materials_name)
            // Важно: в разных таблицах (tools/consumables) уникального индекса может не быть — но проверка не мешает.
            $nameEsc = db_escape($name);
            $dup = db_fetch_one(db_query("SELECT id FROM `$table` WHERE name='$nameEsc' LIMIT 1"));
            if ($dup && (int)$dup['id'] !== $id) {
                materials_flash_set('mat_err','Материал с таким названием уже существует. Измените название.');
            } else {

                $sets = [];
                if (materials__has_col($table,'category_id')) $sets[] = "category_id=".($cat_id>0?$cat_id:"NULL");
                if (materials__has_col($table,'code')) $sets[] = "code='".db_escape($code)."'";
                if (materials__has_col($table,'name')) $sets[] = "name='$nameEsc'";
                if (materials__has_col($table,'unit')) $sets[] = "unit='".db_escape($unit)."'";
                if (materials__has_col($table,'description')) $sets[] = "description='".db_escape($desc)."'";
                if (materials__has_col($table,'is_active')) $sets[] = "is_active=$is_active";

                if ($whereType && materials__has_col($table,'type')) {
                    if (preg_match("/type='([^']+)'/",$whereType,$m)) $sets[] = "type='".db_escape($m[1])."'";
                }

                $priceCol = materials__price_col($table);
                if ($priceCol) {
                    $p = ($price_in==='' ? "NULL" : ("'".db_escape(str_replace(',','.', $price_in))."'"));
                    $sets[] = "$priceCol=$p";
                }

                if ($hasMinimum) {
                    $mn = ($min_in==='' ? "0" : ("'".db_escape(str_replace(',','.', $min_in))."'"));
                    $sets[] = "minimum_qty=$mn";
                }

                try {
                    if ($id>0) {
                        $setSql = implode(",
                    ", $sets);
                        db_query("UPDATE `$table` SET
                    $setSql
                    WHERE id=$id");
                        if (function_exists('audit')) audit('UPDATE',$table,$id,(int)$u['id'], ['event'=>'Материал обновлён','table'=>$table,'id'=>$id,'name'=>$name], 'materials');
                    } else {
                        if (materials__has_col($table,'created_at')) $sets[] = "created_at=NOW()";

                        $cols=[]; $vals=[];
                        foreach ($sets as $s) { $p=explode("=", $s, 2); $cols[]=trim($p[0]); $vals[]=trim($p[1]); }
                        db_query("INSERT INTO `$table` (".implode(",",$cols).") VALUES (".implode(",",$vals).")");
                        // В проекте используется db_last_id() (mysqli_insert_id), а db_insert_id() не определена
                        $id = (int)db_last_id();
                        if (function_exists('audit')) audit('CREATE',$table,$id,(int)$u['id'], ['event'=>'Материал создан','table'=>$table,'id'=>$id,'name'=>$name], 'materials');
                    }

                    header("Location: index.php?m=materials&a=edit&type=$type&id=$id&ok=1");
                    exit;

                } catch (Throwable $e) {
                    // На случай если уникальность всё же поймали на уровне БД
                    $msg = $e->getMessage();
                    if (stripos($msg, 'Duplicate entry') !== false) {
                        materials_flash_set('mat_err','Материал с таким названием уже существует. Измените название.');
                    } else {
                        materials_flash_set('mat_err','Ошибка сохранения: '.$msg);
                    }
                }
            }
        }
    }

    render('materials/edit', [
        'u'=>$u,'type'=>$type,'row'=>$row,'cats'=>$cats,'id'=>$id,
        'price_col'=>materials__price_col($table),
        'has_minimum'=>$hasMinimum
    ]);
}
}
