-- db/update_015_audit_logs_create.sql
-- Создание новой таблицы audit_logs (если нет). Имя FK уникальное.
SET NAMES utf8mb4;

CREATE TABLE IF NOT EXISTS audit_logs (
  id BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
  created_at DATETIME NOT NULL,
  user_id INT UNSIGNED NOT NULL,
  module VARCHAR(64) NOT NULL DEFAULT '',
  action VARCHAR(32) NOT NULL DEFAULT '',
  table_name VARCHAR(64) NOT NULL DEFAULT '',
  row_id BIGINT NOT NULL DEFAULT 0,
  ip VARCHAR(64) NOT NULL DEFAULT '',
  user_agent VARCHAR(255) NOT NULL DEFAULT '',
  details MEDIUMTEXT,
  PRIMARY KEY (id),
  KEY idx_created_at (created_at),
  KEY idx_user (user_id),
  KEY idx_module (module),
  KEY idx_action (action),
  KEY idx_table (table_name),
  CONSTRAINT fk_audit_logs_user FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
