-- db/update_013_finance_adjustments.sql
-- Финансы (ФОТ): премии/штрафы + настройки зарплаты бригадира (оклад + %)
SET NAMES utf8mb4;

ALTER TABLE employees
  ADD COLUMN brigadier_base_salary DECIMAL(14,2) NOT NULL DEFAULT 0 AFTER photo_path,
  ADD COLUMN brigadier_percent DECIMAL(6,2) NOT NULL DEFAULT 0 AFTER brigadier_base_salary;

CREATE TABLE IF NOT EXISTS employee_adjustments (
  id BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
  adj_date DATE NOT NULL,
  employee_id INT UNSIGNED NOT NULL,
  adj_type ENUM('bonus','penalty') NOT NULL,
  amount DECIMAL(14,2) NOT NULL,
  reason VARCHAR(255) NOT NULL DEFAULT '',
  comment TEXT,
  created_at DATETIME NOT NULL,
  created_by INT UNSIGNED NOT NULL,
  is_deleted TINYINT(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (id),
  KEY idx_adj_date (adj_date),
  KEY idx_adj_emp (employee_id),
  CONSTRAINT fk_adj_emp FOREIGN KEY (employee_id) REFERENCES employees(id) ON DELETE RESTRICT,
  CONSTRAINT fk_adj_user FOREIGN KEY (created_by) REFERENCES users(id) ON DELETE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
