-- db/update_005_parts.sql
-- Детали: карточка + спецификация материалов + маршрут операций
SET NAMES utf8mb4;

CREATE TABLE IF NOT EXISTS parts (
  id INT UNSIGNED NOT NULL AUTO_INCREMENT,
  name VARCHAR(255) NOT NULL,
  code VARCHAR(64) NOT NULL DEFAULT '',
  workshop_id INT UNSIGNED NOT NULL,
  daily_plan INT UNSIGNED NOT NULL DEFAULT 0,
  qty_per_product_default DECIMAL(14,3) NOT NULL DEFAULT 1,
  description TEXT,
  is_active TINYINT(1) NOT NULL DEFAULT 1,
  created_at DATETIME NOT NULL,
  PRIMARY KEY (id),
  KEY idx_parts_ws (workshop_id),
  KEY idx_parts_name (name),
  CONSTRAINT fk_parts_ws FOREIGN KEY (workshop_id) REFERENCES workshops(id) ON DELETE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS part_materials (
  id INT UNSIGNED NOT NULL AUTO_INCREMENT,
  part_id INT UNSIGNED NOT NULL,
  material_id INT UNSIGNED NOT NULL,
  qty_per_part DECIMAL(14,3) NOT NULL DEFAULT 0,
  PRIMARY KEY (id),
  KEY idx_pm_part (part_id),
  KEY idx_pm_mat (material_id),
  CONSTRAINT fk_pm_part FOREIGN KEY (part_id) REFERENCES parts(id) ON DELETE CASCADE,
  CONSTRAINT fk_pm_mat FOREIGN KEY (material_id) REFERENCES materials(id) ON DELETE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS part_operations (
  id INT UNSIGNED NOT NULL AUTO_INCREMENT,
  part_id INT UNSIGNED NOT NULL,
  operation_id INT UNSIGNED NOT NULL,
  qty_per_part DECIMAL(14,3) NOT NULL DEFAULT 1,
  PRIMARY KEY (id),
  KEY idx_po_part (part_id),
  KEY idx_po_op (operation_id),
  CONSTRAINT fk_po_part FOREIGN KEY (part_id) REFERENCES parts(id) ON DELETE CASCADE,
  CONSTRAINT fk_po_op FOREIGN KEY (operation_id) REFERENCES operations(id) ON DELETE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
