-- db/update_004_workshops_duplicates.sql
-- Разрешаем одинаковые названия цехов в разных локациях.
-- Также: добавляем безопасное удаление локаций/цехов (логика в PHP).
SET NAMES utf8mb4;

-- Попытка удалить уникальный индекс uq_workshop_loc_name если он есть
-- (название индекса может отличаться; ниже — самый частый вариант)
ALTER TABLE workshops DROP INDEX uq_workshop_loc_name;

-- Если индекс называется по-другому, и команда выше даст ошибку:
-- SHOW INDEX FROM workshops;
-- и удалите нужный UNIQUE индекс вручную.
