-- db/update_001_materials.sql
-- Добавляет: категории материалов + материалы/инструмент/расходники + минимумы по локациям + поля "заказано"
SET NAMES utf8mb4;

CREATE TABLE IF NOT EXISTS material_categories (
  id INT UNSIGNED NOT NULL AUTO_INCREMENT,
  name VARCHAR(150) NOT NULL,
  description TEXT,
  PRIMARY KEY (id),
  UNIQUE KEY uq_matcat_name (name)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Материалы
CREATE TABLE IF NOT EXISTS materials (
  id INT UNSIGNED NOT NULL AUTO_INCREMENT,
  code VARCHAR(64) DEFAULT '',
  name VARCHAR(255) NOT NULL,
  category_id INT UNSIGNED DEFAULT NULL,
  unit VARCHAR(32) NOT NULL DEFAULT '',
  current_price DECIMAL(12,2) DEFAULT NULL,
  description TEXT,
  is_active TINYINT(1) NOT NULL DEFAULT 1,
  created_at DATETIME NOT NULL,
  PRIMARY KEY (id),
  KEY idx_materials_cat (category_id),
  UNIQUE KEY uq_materials_name (name),
  CONSTRAINT fk_materials_cat FOREIGN KEY (category_id) REFERENCES material_categories(id) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS material_location (
  material_id INT UNSIGNED NOT NULL,
  location_id INT UNSIGNED NOT NULL,
  min_qty DECIMAL(14,3) NOT NULL DEFAULT 0,
  ordered_qty DECIMAL(14,3) NOT NULL DEFAULT 0,
  expected_date DATE DEFAULT NULL,
  is_ordered TINYINT(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (material_id, location_id),
  CONSTRAINT fk_matloc_mat FOREIGN KEY (material_id) REFERENCES materials(id) ON DELETE CASCADE,
  CONSTRAINT fk_matloc_loc FOREIGN KEY (location_id) REFERENCES locations(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Инструмент
CREATE TABLE IF NOT EXISTS tools (
  id INT UNSIGNED NOT NULL AUTO_INCREMENT,
  code VARCHAR(64) DEFAULT '',
  name VARCHAR(255) NOT NULL,
  category_id INT UNSIGNED DEFAULT NULL,
  current_price DECIMAL(12,2) DEFAULT NULL,
  description TEXT,
  is_active TINYINT(1) NOT NULL DEFAULT 1,
  created_at DATETIME NOT NULL,
  PRIMARY KEY (id),
  KEY idx_tools_cat (category_id),
  UNIQUE KEY uq_tools_name (name),
  CONSTRAINT fk_tools_cat FOREIGN KEY (category_id) REFERENCES material_categories(id) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS tool_location (
  tool_id INT UNSIGNED NOT NULL,
  location_id INT UNSIGNED NOT NULL,
  min_qty DECIMAL(14,3) NOT NULL DEFAULT 0,
  ordered_qty DECIMAL(14,3) NOT NULL DEFAULT 0,
  expected_date DATE DEFAULT NULL,
  is_ordered TINYINT(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (tool_id, location_id),
  CONSTRAINT fk_toolloc_tool FOREIGN KEY (tool_id) REFERENCES tools(id) ON DELETE CASCADE,
  CONSTRAINT fk_toolloc_loc FOREIGN KEY (location_id) REFERENCES locations(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Расходные материалы
CREATE TABLE IF NOT EXISTS consumables (
  id INT UNSIGNED NOT NULL AUTO_INCREMENT,
  code VARCHAR(64) DEFAULT '',
  name VARCHAR(255) NOT NULL,
  category_id INT UNSIGNED DEFAULT NULL,
  unit VARCHAR(32) NOT NULL DEFAULT '',
  current_price DECIMAL(12,2) DEFAULT NULL,
  description TEXT,
  is_active TINYINT(1) NOT NULL DEFAULT 1,
  created_at DATETIME NOT NULL,
  PRIMARY KEY (id),
  KEY idx_cons_cat (category_id),
  UNIQUE KEY uq_consumables_name (name),
  CONSTRAINT fk_cons_cat FOREIGN KEY (category_id) REFERENCES material_categories(id) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS consumable_location (
  consumable_id INT UNSIGNED NOT NULL,
  location_id INT UNSIGNED NOT NULL,
  min_qty DECIMAL(14,3) NOT NULL DEFAULT 0,
  ordered_qty DECIMAL(14,3) NOT NULL DEFAULT 0,
  expected_date DATE DEFAULT NULL,
  is_ordered TINYINT(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (consumable_id, location_id),
  CONSTRAINT fk_consloc_cons FOREIGN KEY (consumable_id) REFERENCES consumables(id) ON DELETE CASCADE,
  CONSTRAINT fk_consloc_loc FOREIGN KEY (location_id) REFERENCES locations(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
