-- db/schema.sql
-- База: ascrm
-- Кодировка
SET NAMES utf8mb4;
SET time_zone = '+00:00';

-- USERS
CREATE TABLE IF NOT EXISTS users (
  id INT UNSIGNED NOT NULL AUTO_INCREMENT,
  login VARCHAR(64) NOT NULL,
  password_hash VARCHAR(255) NOT NULL,
  full_name VARCHAR(255) NOT NULL,
  position VARCHAR(255) DEFAULT '',
  role ENUM('admin','director','prod_head','brigadier','otk','storekeeper') NOT NULL,
  telegram_id VARCHAR(64) DEFAULT '',
  is_active TINYINT(1) NOT NULL DEFAULT 1,
  created_at DATETIME NOT NULL,
  PRIMARY KEY (id),
  UNIQUE KEY uq_users_login (login)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS locations (
  id INT UNSIGNED NOT NULL AUTO_INCREMENT,
  name VARCHAR(150) NOT NULL,
  PRIMARY KEY (id),
  UNIQUE KEY uq_locations_name (name)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS workshops (
  id INT UNSIGNED NOT NULL AUTO_INCREMENT,
  location_id INT UNSIGNED NOT NULL,
  name VARCHAR(150) NOT NULL,
  PRIMARY KEY (id),
  UNIQUE KEY uq_workshops_loc_name (location_id, name),
  KEY idx_workshops_location (location_id),
  CONSTRAINT fk_workshops_location FOREIGN KEY (location_id) REFERENCES locations(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Пользователь -> доступные локации (несколько)
CREATE TABLE IF NOT EXISTS user_locations (
  user_id INT UNSIGNED NOT NULL,
  location_id INT UNSIGNED NOT NULL,
  PRIMARY KEY (user_id, location_id),
  KEY idx_ul_location (location_id),
  CONSTRAINT fk_ul_user FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
  CONSTRAINT fk_ul_location FOREIGN KEY (location_id) REFERENCES locations(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Логи CRUD (в БД)
CREATE TABLE IF NOT EXISTS audit_log (
  id BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
  created_at DATETIME NOT NULL,
  user_id INT UNSIGNED DEFAULT NULL,
  entity VARCHAR(64) NOT NULL,        -- например: users, locations
  entity_id VARCHAR(64) DEFAULT '',
  action ENUM('CREATE','UPDATE','DELETE','CORRECT','LOGIN','LOGOUT') NOT NULL,
  details JSON NULL,
  PRIMARY KEY (id),
  KEY idx_audit_user (user_id),
  KEY idx_audit_entity (entity, entity_id),
  KEY idx_audit_created (created_at),
  CONSTRAINT fk_audit_user FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Системные настройки (позже сюда перенесём Telegram token и др.)
CREATE TABLE IF NOT EXISTS app_settings (
  `key` VARCHAR(100) NOT NULL,
  `value` TEXT NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Стартовый админ
INSERT INTO users(login,password_hash,full_name,position,role,telegram_id,is_active,created_at)
SELECT 'admin', '$2y$10$X.gdSbzg/3BTe112Kpyy.ekPbPGg8QauCWE5s80Bsm5AoJSTXBz9a', 'Администратор', 'Администратор', 'admin', '', 1, NOW()
WHERE NOT EXISTS (SELECT 1 FROM users WHERE login='admin');

-- ВАЖНО:
-- Хеш выше соответствует паролю: admin123
