// assets/app.js
(function(){
  // Theme init: localStorage > system
  try{
    const saved = localStorage.getItem('ascrm_theme');
    const prefersDark = window.matchMedia && window.matchMedia('(prefers-color-scheme: dark)').matches;
    const theme = saved ? saved : (prefersDark ? 'dark' : 'light');
    document.documentElement.setAttribute('data-theme', theme);
  }catch(e){}

  // Theme toggle
  document.addEventListener('click', function(ev){
    const btn = ev.target.closest && ev.target.closest('#themeToggle');
    if(!btn) return;
    const cur = document.documentElement.getAttribute('data-theme') || 'light';
    const next = (cur === 'dark') ? 'light' : 'dark';
    document.documentElement.setAttribute('data-theme', next);
    try{ localStorage.setItem('ascrm_theme', next); }catch(e){}
  });

  // Optional: dashboard feed auto refresh (if element exists)
  const feed = document.getElementById('feed');
  if(feed){
    setInterval(() => {
      const now = new Date();
      const el = document.createElement('div');
      el.className = 'feed-item';
      el.innerHTML = `
        <div class="dot warn"></div>
        <div>
          <div class="feed-title">Автообновление</div>
          <div class="feed-sub muted">Время: ${now.toLocaleTimeString()}</div>
        </div>
        <div class="feed-time muted">AJAX</div>
      `;
      feed.prepend(el);
      while(feed.children.length > 5) feed.removeChild(feed.lastElementChild);
    }, 60000);
  }
})();
