<?php
// app/product_warehouse.php — склад готовой продукции (балансы/отгрузки)
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/audit.php';

function pw_get_balance($location_id, $product_id) {
    $location_id = (int)$location_id;
    $product_id = (int)$product_id;

    $row = db_fetch_one(db_query("
      SELECT COALESCE(SUM(delta),0) AS bal FROM (
        SELECT qty AS delta
        FROM product_moves
        WHERE location_id=$location_id AND product_id=$product_id AND is_reversed=0
          AND move_type IN ('in','adjust','reverse')
        UNION ALL
        SELECT -qty AS delta
        FROM product_moves
        WHERE location_id=$location_id AND product_id=$product_id AND is_reversed=0
          AND move_type='ship'
      ) t
    "));
    return $row ? (float)$row['bal'] : 0.0;
}

function pw_list_balances($location_id) {
    $location_id = (int)$location_id;
    return db_fetch_all(db_query("
      SELECT p.id, p.name,
        COALESCE((
          SELECT SUM(delta) FROM (
            SELECT qty AS delta
            FROM product_moves m
            WHERE m.location_id=$location_id AND m.product_id=p.id AND m.is_reversed=0 AND m.move_type IN ('in','adjust','reverse')
            UNION ALL
            SELECT -qty AS delta
            FROM product_moves m
            WHERE m.location_id=$location_id AND m.product_id=p.id AND m.is_reversed=0 AND m.move_type='ship'
          ) x
        ),0) AS bal
      FROM products p
      WHERE p.is_active=1
      ORDER BY p.name
    "));
}

function pw_create_shipment($location_id, $product_id, $qty, $customer, $doc_no, $comment, $user_id) {
    $location_id = (int)$location_id;
    $product_id = (int)$product_id;
    $qty = (float)$qty;
    $user_id = (int)$user_id;

    $customer_esc = db_escape($customer);
    $doc_esc = db_escape($doc_no);
    $comment_esc = db_escape($comment);

    // header
    db_query("INSERT INTO product_shipments(location_id,customer,doc_no,comment,shipped_at,created_by)
              VALUES ($location_id,'$customer_esc','$doc_esc','$comment_esc',NOW(),$user_id)");
    $ship_id = (int)db_last_id();

    // move
    db_query("INSERT INTO product_moves(location_id,product_id,move_type,qty,reason,comment,created_at,created_by)
              VALUES ($location_id,$product_id,'ship',$qty,'Отгрузка','$comment_esc',NOW(),$user_id)");
    $move_id = (int)db_last_id();

    db_query("INSERT INTO product_shipment_items(shipment_id,product_id,qty,move_id)
              VALUES ($ship_id,$product_id,$qty,$move_id)");

    audit('CREATE','product_shipments',$ship_id,$user_id, ['location_id'=>$location_id,'product_id'=>$product_id,'qty'=>$qty]);

    return $ship_id;
}

function pw_cancel_shipment($shipment_id, $reason, $user_id) {
    $shipment_id = (int)$shipment_id;
    $user_id = (int)$user_id;
    $reason_esc = db_escape($reason);

    $ship = db_fetch_one(db_query("SELECT * FROM product_shipments WHERE id=$shipment_id LIMIT 1"));
    if (!$ship) return false;
    if ((int)$ship['is_canceled']===1) return true;

    // возвращаем склад: для каждой строки создаём reverse move (поступление)
    $items = db_fetch_all(db_query("SELECT * FROM product_shipment_items WHERE shipment_id=$shipment_id"));
    foreach ($items as $it) {
        $move_id = (int)($it['move_id'] ?? 0);
        $loc = (int)$ship['location_id'];
        $prod = (int)$it['product_id'];
        $qty = (float)$it['qty'];

        db_query("INSERT INTO product_moves(location_id,product_id,move_type,qty,reason,comment,reversed_of,created_at,created_by)
                  VALUES ($loc,$prod,'reverse',$qty,'Отмена отгрузки','$reason_esc',$move_id,NOW(),$user_id)");
        db_query("UPDATE product_moves SET is_reversed=1 WHERE id=$move_id");
    }

    db_query("UPDATE product_shipments
              SET is_canceled=1, canceled_at=NOW(), canceled_by=$user_id, cancel_reason='$reason_esc'
              WHERE id=$shipment_id");

    audit('UPDATE','product_shipments',$shipment_id,$user_id, ['canceled'=>1,'reason'=>$reason]);

    return true;
}
