<?php
// app/part_place.php — остатки деталей у "места" (цех/сотрудник)
require_once __DIR__ . '/db.php';

function pp_get_balance($location_id, $place_type, $place_id, $part_id) {
    $location_id = (int)$location_id;
    $place_id = (int)$place_id;
    $part_id = (int)$part_id;
    $place_type = ($place_type==='employee') ? 'employee' : 'workshop';

    $row = db_fetch_one(db_query("
      SELECT COALESCE(SUM(delta),0) AS bal FROM (
        SELECT qty AS delta
        FROM part_place_moves
        WHERE location_id=$location_id AND place_type='$place_type' AND place_id=$place_id AND part_id=$part_id AND move_type IN ('in','adjust','reverse')
        UNION ALL
        SELECT -qty AS delta
        FROM part_place_moves
        WHERE location_id=$location_id AND place_type='$place_type' AND place_id=$place_id AND part_id=$part_id AND move_type='out'
      ) t
    "));
    return $row ? (float)$row['bal'] : 0.0;
}

function pp_add_in_from_issue($location_id, $place_type, $place_id, $part_id, $qty, $comment, $user_id) {
    $location_id=(int)$location_id; $place_id=(int)$place_id; $part_id=(int)$part_id; $qty=(float)$qty; $user_id=(int)$user_id;
    $place_type = ($place_type==='employee') ? 'employee' : 'workshop';
    $comment_esc = db_escape($comment);

    db_query("INSERT INTO part_place_moves(location_id,place_type,place_id,part_id,move_type,qty,reason,comment,created_at,created_by)
              VALUES ($location_id,'$place_type',$place_id,$part_id,'in',$qty,'Получение деталей','$comment_esc',NOW(),$user_id)");
    return (int)db_last_id();
}

function pp_add_out_consume($location_id, $place_type, $place_id, $part_id, $qty, $comment, $user_id) {
    $location_id=(int)$location_id; $place_id=(int)$place_id; $part_id=(int)$part_id; $qty=(float)$qty; $user_id=(int)$user_id;
    $place_type = ($place_type==='employee') ? 'employee' : 'workshop';
    $comment_esc = db_escape($comment);

    db_query("INSERT INTO part_place_moves(location_id,place_type,place_id,part_id,move_type,qty,reason,comment,created_at,created_by)
              VALUES ($location_id,'$place_type',$place_id,$part_id,'out',$qty,'Списание на комплектацию','$comment_esc',NOW(),$user_id)");
    return (int)db_last_id();
}
