<?php
// app/menu_acl.php
// Видимость пунктов меню по ролям (только отображение; права в контроллерах остаются как есть)

if (!function_exists('menu_can')) {
function menu_can($u, $key) {
    $role = is_array($u) ? ($u['role'] ?? '') : '';
    $map = [
        // Дашборд: только директор и админ
        'dashboard'  => ['admin','director'],

        'materials'  => ['admin','director','prod_head','storekeeper'],
        'parts'      => ['admin','director','prod_head'],
        'production' => ['admin','director','prod_head','brigadier'],
        'planfact'   => ['admin','director','prod_head'],

        // СКЛАД: бригадиру НЕ показываем в меню
        'warehouse'  => ['admin','director','prod_head','storekeeper'],

        'quality'    => ['admin','director','otk'],
        'staff'      => ['admin','director','prod_head'],
        'finance'    => ['admin','director','prod_head'],
        'settings'   => ['admin','director'],
    ];
    return isset($map[$key]) && in_array($role, $map[$key], true);
}
}
