<?php
// app/logger.php
function log_path() {
    return dirname(__DIR__) . '/logs/app.log';
}

function log_line($level, $event, $data = []) {
    $ts = date('Y-m-d H:i:s');
    $line = $ts . " [$level] $event " . json_encode($data, JSON_UNESCAPED_UNICODE) . "\n";
    @file_put_contents(log_path(), $line, FILE_APPEND);
}

function log_error($event, $data = []) {
    log_line('ERROR', $event, $data);
}

function log_info($event, $data = []) {
    log_line('INFO', $event, $data);
}
