<?php
require_once dirname(__DIR__, 2) . '/app/auth.php';
require_once dirname(__DIR__, 2) . '/app/view.php';
$u = auth_user();
$cfg = require dirname(__DIR__, 2) . '/app/config.php';

$module = defined('ASCRM_MODULE') ? ASCRM_MODULE : '';
function nav_item($m, $title, $ico, $href){
  global $module;
  $active = ($module === $m) ? 'active' : '';
  echo '<a class="nav-item ' . $active . '" href="' . h($href) . '"><span class="nav-ico">' . $ico . '</span><span class="nav-title">' . h($title) . '</span></a>';
}
?>
<!doctype html>
<html lang="ru">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= h($cfg['app_name']) ?></title>
  <link rel="stylesheet" href="assets/style.css?v=3">
  <link rel="stylesheet" href="assets/forms.css?v=1">
  <script src="assets/app.js?v=2" defer></script>
</head>
<body>
<div class="app-shell">

  <header class="app-header">
    <div class="brand">
      <div class="logo">AS</div>
      <div class="brand-text">
        <div class="brand-title"><?= h($cfg['app_name']) ?></div>
        <div class="brand-sub muted">CRM производства</div>
      </div>
    </div>

    <?php if ($u): ?>
    <div class="header-actions">
      <button class="btn icon" id="themeToggle" type="button" title="Сменить тему">
        <span class="icon-moon" aria-hidden="true">🌙</span>
        <span class="icon-sun" aria-hidden="true">☀️</span>
        <span class="sr-only">Сменить тему</span>
      </button>

      <div class="userbox">
        <div class="userbox-name"><?= h($u['full_name']) ?></div>
        <a class="link" href="index.php?m=auth&a=logout">Выход</a>
      </div>
    </div>
    <?php endif; ?>
  </header>

		<?php if ($u): ?>
		<aside class="app-sidebar">
		  <nav class="nav">
			<?php require_once __DIR__ . '/../../app/menu_acl.php'; ?>
			<?php if (menu_can($u,'dashboard'))  nav_item('dashboard', 'Дашборд', '🏠', 'index.php'); ?>
			<?php if (menu_can($u,'materials'))  nav_item('materials', 'Материал', '📦', 'index.php?m=materials&a=index'); ?>
			<?php if (menu_can($u,'parts'))      nav_item('parts', 'Детали', '🧩', 'index.php?m=parts&a=index'); ?>
			<?php if (menu_can($u,'production')) nav_item('production', 'Производство', '🏭', 'index.php?m=production&a=index'); ?>
			<?php if (menu_can($u,'planfact'))   nav_item('planfact', 'План/Факт', '📈', 'index.php?m=planfact&a=index'); ?>
			<?php if (menu_can($u,'warehouse'))  nav_item('warehouse', 'Склад', '🗄️', 'index.php?m=warehouse&a=index'); ?>
			<?php if (menu_can($u,'quality'))    nav_item('quality', 'Качество', '🧪', 'index.php?m=quality&a=index'); ?>
			<?php if (menu_can($u,'staff'))      nav_item('staff', 'Персонал', '👷', 'index.php?m=staff&a=index'); ?>
			<?php if (menu_can($u,'finance'))    nav_item('finance', 'Финансы', '💳', 'index.php?m=finance&a=index'); ?>
			<?php if (menu_can($u,'settings'))   nav_item('settings', 'Настройки', '⚙️', 'index.php?m=settings&a=users'); ?>
		  </nav>
		</aside>
		<?php endif; ?>

  <main class="app-main">
