<?php
// app/audit.php
// Логирование действий (в БД + файл).
// Совместимо с двумя вариантами таблиц: audit_logs (новая) и audit_log (старая).
require_once __DIR__ . '/db.php';

if (!function_exists('audit')) {

function audit_table_exists($table) {
    $table = db_escape($table);
    $res = @mysqli_query(db(), "SELECT 1 FROM information_schema.tables WHERE table_schema = DATABASE() AND table_name='$table' LIMIT 1");
    if (!$res) return false;
    $row = mysqli_fetch_row($res);
    return !empty($row);
}

/**
 * audit($action, $entity, $entity_id, $user_id, $details=null, $module=null)
 */
function audit($action, $entity, $entity_id, $user_id, $details = null, $module = null) {
    // защита от рекурсии через db_query()
    $GLOBALS['AUDIT_INTERNAL'] = 1;

    $action = (string)$action;
    $entity = (string)$entity;
    $entity_id = (string)$entity_id;
    $user_id = $user_id ? (int)$user_id : 0;
    $module = ($module === null) ? (string)($_GET['m'] ?? '') : (string)$module;

    $details_txt = null;
    if ($details !== null) {
        if (is_array($details) || is_object($details)) {
            $details_txt = json_encode($details, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES);
        } else {
            $details_txt = (string)$details;
        }
    }

    // Пишем в БД: audit_logs (если есть), иначе audit_log (старый формат)
    if (audit_table_exists('audit_logs')) {
        $ip = (string)($_SERVER['REMOTE_ADDR'] ?? '');
        $ua = (string)($_SERVER['HTTP_USER_AGENT'] ?? '');
        $act = db_escape($action);
        $tbl = db_escape($entity);
        $mod = db_escape($module);
        $ip_esc = db_escape($ip);
        $ua_esc = db_escape(mb_substr($ua, 0, 255));
        $det = db_escape($details_txt ?? '');

        db_query("INSERT INTO audit_logs(created_at,user_id,module,action,table_name,row_id,ip,user_agent,details)
                  VALUES (NOW(),".(int)$user_id.",'$mod','$act','$tbl',".(int)$entity_id.",'$ip_esc','$ua_esc','$det')");
    } else if (audit_table_exists('audit_log')) {
        $action_esc = db_escape($action);
        $entity_esc = db_escape($entity);
        $entity_id_esc = db_escape($entity_id);
        $uid = $user_id ? (int)$user_id : 'NULL';

        $json = 'NULL';
        if ($details_txt !== null) {
            $json = "'" . db_escape($details_txt) . "'";
        }
        db_query("INSERT INTO audit_log(created_at,user_id,entity,entity_id,action,details)
                  VALUES (NOW(), $uid, '$entity_esc', '$entity_id_esc', '$action_esc', $json)");
    }

    // Пишем в файл
    audit_write_file($user_id, $module, $action, $entity, $entity_id, $details_txt);

    $GLOBALS['AUDIT_INTERNAL'] = 0;
}

function audit_write_file($user_id, $module, $action, $entity, $entity_id, $details_txt) {
    $root = dirname(__DIR__);
    $dir = $root . '/logs';
    if (!is_dir($dir)) @mkdir($dir, 0775, true);
    $file = $dir . '/audit.log';

    $ip = (string)($_SERVER['REMOTE_ADDR'] ?? '');
    $line = date('Y-m-d H:i:s')
        . " | user:$user_id"
        . " | m:$module"
        . " | $action"
        . " | $entity#$entity_id"
        . " | ip:$ip"
        . " | " . (string)($details_txt ?? '');

    @file_put_contents($file, $line . PHP_EOL, FILE_APPEND | LOCK_EX);
}

} // function_exists audit
